#ifndef __TABLE_H__
#define __TABLE_H__ 1

#include <windows.h>

/*

TABLE BINARY FORMAT:

First DWORD in a binary table is the file Size, then follows the first level of the encoding tree.
There will be no root node of this tree.

+----------------+--------------------------------+--------------------------------+--------------------------+------
|FileSize in Byte|          First Node            | Second Node of the same level  | Third Node at this level | ...
+----------------+--------------------------------+--------------------------------+--------------------------+------
|    4  Byte     |  Unknown Length but > 10 Byte  |  Unknown Length but > 10 Byte  |             ....         | ...
+----------------+--------------------------------+--------------------------------+--------------------------+------


Every node is recursive defined :

+----------------+--------+----------------+--------------------------------+---------------------------+
| offset to the  | UTF-16 |offset to the   | UTF16 strings, end with '\0'   | follow Nodes, which from  |
|   next node    | WChar  |end of results  | the path from root to this node| next level                |
| == Node Size   |  key   |incl. this field| is the encode of these strings |                           |
+----------------+--------+----------------+--------------------------------+---------------------------+
|    4  Byte     | 2 Byte |    4  Byte     |     Unknown Length             |	   Unknow Length        |
+----------------+--------+----------------+--------------------------------+---------------------------+

*/




#define RESULT_MAX 50
#define KEY_MAX 50

typedef void Table;

typedef struct {
	LPTSTR result[RESULT_MAX];
	TCHAR key[RESULT_MAX][KEY_MAX+1]; /* KEY_MAX+1 for '\0' */
	int n; /* how many element of every array were filled */
	int tokenLength; /* how many keychars from the query alphabeta consumed */
} TableResponse;


int tableQuery(Table *table, LPTSTR key, TableResponse *res);
void unloadTable(HLOCAL hRaw);
Table *loadTable(LPTSTR tablePath);


#endif /* __TABLE_H__ */
