#include <windows.h>

#include "table.h"


void unloadTable(HLOCAL hRaw)
{
	if (hRaw == NULL) {
		LocalFree(hRaw);
		hRaw = NULL;
	}
}

Table *loadTable(LPTSTR tablePath)
{
	HANDLE hDB;
	HLOCAL hRaw = NULL;
	DWORD size, actually;

	if (hRaw == NULL) {
		LocalFree(hRaw);
		hRaw = NULL;
	}

	hDB = CreateFile(tablePath, FILE_READ_DATA, FILE_SHARE_READ,
			NULL, OPEN_EXISTING, FILE_ATTRIBUTE_NORMAL, NULL);
	if (hDB == INVALID_HANDLE_VALUE) {
		MessageBox(NULL, TEXT("Could not open table file"),
			   TEXT("Loading Table Error"), (MB_ICONERROR|MB_OK) );
		return NULL;
	}

	size = GetFileSize(hDB, NULL);
	hRaw = LocalAlloc(LMEM_FIXED, size + 4);

	if (hRaw == NULL) {
		MessageBox(NULL, TEXT("LocalAlloc() failed"),
			   TEXT("Loading Table Error"), (MB_ICONERROR|MB_OK) );
		return NULL;
	}
	
	if (!ReadFile(hDB, hRaw, size, &actually, NULL) ||
	    (size != actually)) {
		MessageBox(NULL, TEXT("Particular error by checking table size"),
			   TEXT("Loading Table Error"), (MB_ICONERROR|MB_OK) );
		return NULL;
	}

	if (!CloseHandle(hDB)) {
		MessageBox(NULL, TEXT("Can not close file"),
			   TEXT("Loading Table Error"), (MB_ICONERROR|MB_OK) );
		return NULL;
	}

	if (size != *(DWORD*)hRaw ) {
		MessageBox(NULL, TEXT("Table size not correct"),
			   TEXT("Loading Table Error"), (MB_ICONERROR|MB_OK) );
		return NULL;
	} 
	return hRaw;
}


void *parseNode(char *base, LPTSTR key, TableResponse *res, LPTSTR prompt)
{
	char *nextNode = base + *(PDWORD)base;
	char *p, *firstLeaf, *pStrings;
	WCHAR ch;
	int numBefore;

	if (res->n >= RESULT_MAX) {
		return nextNode;
	}

	p = base + sizeof(DWORD);

	/* 2. field: CharCode of the Node */
	ch = *(PWCHAR)p;

	if (key[0] == ch) {
		res->tokenLength++;
	} else if (key[0] != 0) {
		return nextNode;
	}

	/* NOW: (key[0] == ch || key[0] == 0) */

	p += sizeof(WCHAR);

	/* 3. field: StringsLength */
	firstLeaf = p + *(PDWORD)p;
	p += sizeof(DWORD);

	/* 4, field: strings of this Node */
	pStrings  = p;

	/* fixsize fields are parsed */

	if (key[0] == 0) {
		/* show Result with same prefix */
		int i;
		/*p = pStrings;*/
		i = lstrlen(prompt);
		prompt[i] = ch;
		prompt[i+1] = 0;
		while (p < firstLeaf && res->n < RESULT_MAX) {

			res->result[res->n] = (LPTSTR)p;
			lstrcpy(&res->key[res->n][0], prompt);
			res->n++;
			while (*(PWCHAR)p != 0) {
				p = (char*)((PWCHAR)p + 1);
			}
			p = (char*)((PWCHAR)p + 1);
		}
		/* p = firstLeaf; */

		while (p < nextNode && res->n < RESULT_MAX) {
			p = (char*)parseNode(p, key, res, prompt);
		}
		prompt[i] = 0;
	} else if (key[1] == 0){
		/* precision match */
		p = pStrings;
		while (p < firstLeaf && res->n < RESULT_MAX) {
			res->result[res->n] = (LPTSTR)p;
			res->key[res->n][0] = 0;
			res->n++;
			while (*(PWCHAR)p != 0) {
				p = (char*)((PWCHAR)p + 1);
			}
			p = (char*)((PWCHAR)p + 1);
		}

		/* iterate leaves */
		/*p = firstLeaf;*/
		while (p < nextNode && res->n < RESULT_MAX) {
			p = (char*)parseNode(p, &key[1], res, prompt);
		}

	} else {
		/* keystroke not Terminated */
		numBefore = res->n;
		p = firstLeaf;
		while (p < nextNode && res->n < RESULT_MAX) {
			p = (char*)parseNode(p, &key[1], res, prompt);
		}
		if (numBefore == res->n && res->n < RESULT_MAX) {
			p = pStrings;
			while (p < firstLeaf && res->n < RESULT_MAX) {
				res->result[res->n] = (LPTSTR)p;
				res->key[res->n][0] = 0;
				res->n++;
				while (*(PWCHAR)p != 0) {
					p = (char*)((PWCHAR)p + 1);
				}
				p = (char*)((PWCHAR)p + 1);
			}
		}
	}

	return nextNode;
}

int tableQuery(Table *table, LPTSTR key, TableResponse *res)
{
	int tableSize = *(PDWORD)table;
	char *p;
	WCHAR prompt[KEY_MAX];

	res->n = 0;
	res->tokenLength = 0;
	prompt[0] = 0;

	if (key[0] == 0) {
		return 0;
	}

	p = (char*)table + sizeof(DWORD);
	while (p < (char*)table + tableSize) {
		p = (char*)parseNode(p, key, res, prompt);
		if (res->n >= RESULT_MAX) {
			break;
		}
	}

	return res->n;
}