#include <windows.h>

#include "main.h"
#include "hook.h"
#include "compose.h"
#include "table.h"


#define KEY_BUF_MAX TARGET_LENGTH
/* terminate keyBuf as String */
#define keyBufTerm() do{ keyBuf[keyBufIndex] = 0; }while(0)
/* attach keyBuf with a new Char */
#define keyBufAddChar(x) do{\
		if (keyBufIndex<KEY_BUF_MAX)\
			keyBuf[keyBufIndex++] = (x);\
	}while(0)

TCHAR keyBuf[KEY_BUF_MAX+1];
int keyBufIndex = 0;
#define displayKeyBuf() do{keyBufTerm(); updateKeyCode(keyBuf);}while(0)


#define CANDIDATES_NUM 5


TableResponse response = {0};
int baseIndex; /* Start candidate index in response  */


void showResponse(TableResponse *res, int *baseIndex)
{
	int i;
	static TCHAR numBuf[10];
	static TCHAR buf[CANDIDATES_NUM*12];

	if (*baseIndex < 0) {
		*baseIndex = 0;
	}

	buf[0] = 0;

	for (i = 0; (i + *baseIndex) < response.n && i < CANDIDATES_NUM; ++i) {
		wsprintf(numBuf, TEXT("%d."), i+1);
		lstrcat(buf, numBuf);
		lstrcat(buf, response.result[*baseIndex + i]);
		lstrcat(buf, response.key[*baseIndex + i]);
		lstrcat(buf, TEXT(""));
	}
	updateCandidate(buf);
}

void translate()
{

	keyBufTerm();

	if (!tableQuery(pTable, keyBuf, &response)) {
		updateCandidate(TEXT(""));
		return;
	}
	baseIndex = 0;
	showResponse(&response, &baseIndex);
}



void compose(TCHAR ch, int nVirtKey, int count)
{
	/* count entspricht ob die Funktion die Macht bernehmen, die Message NIE weiter zu leiten */
	/* count = 0 : weiter leiten, sonst nicht */

	int breakFlag = 1;  /* ob aus */
	while ((count > 0) && breakFlag) {
		switch (nVirtKey) {
			case VK_RETURN:
				if (keyBufIndex) {
					keyBufTerm();
					setOutput(keyBuf);
					keyBufIndex = 0;
					keyBuf[0] = 0;
					count--;
					displayKeyBuf();
				} else {
					breakFlag = 0;
				}
				break;
			case VK_BACK:
				if (keyBufIndex > 0) {
					keyBufIndex--;
					count--;
					translate();
					displayKeyBuf();
				} else {
					breakFlag = 0;
				}
				break;
			case VK_SPACE:
				if (response.n > 0 && ((keyBufIndex +1) >= response.tokenLength)) {
					count--;
					setOutput(response.result[0]);
					keyBufIndex -= response.tokenLength;
					lstrcpy(keyBuf, &keyBuf[response.tokenLength]);
					displayKeyBuf();
					translate();
				} else {
					breakFlag = 0;
				}
				break;
			case VK_ESCAPE:
				if(keyBufIndex) {
					count--;
					keyBufIndex = 0;
					keyBufTerm();
					translate();
					displayKeyBuf();
				} else {
					breakFlag = 0;
				}
				break;
			case VK_PRIOR:
				if (response.n > 0) {
					baseIndex -= CANDIDATES_NUM;
					if (baseIndex < 0) {
						baseIndex = 0;
					}
					showResponse(&response, &baseIndex);
					count--;
				} else {
					breakFlag = 0;
				}
				break;
			case VK_NEXT:
				if (response.n > 0) {
					if (baseIndex + CANDIDATES_NUM < response.n) {
						baseIndex += CANDIDATES_NUM;
					}
					showResponse(&response, &baseIndex);
					count--;
				} else {
					breakFlag = 0;
				}
				break;
			default:
				if (ch >= 'a' && ch <= 'z') {
					keyBufAddChar(ch); 
					count--;
					translate();
					displayKeyBuf();
				} else if (ch >= '0' && ch <= '9' && response.n > 0) {
					int i = ch - '0';
					count--;
					if (i>0 && response.n >= i && i <= CANDIDATES_NUM) {
						setOutput(response.result[baseIndex + i - 1]);
						keyBufIndex -= response.tokenLength;
						lstrcpy(keyBuf, &keyBuf[response.tokenLength]);
						displayKeyBuf();
						translate();
					}
				} else {
					breakFlag = 0;
				}
		}
	}

	/* falls `count` nimmt auf 0 ab, dann wird
	   der Tastedruck nicht mehr weitergeleitet */
	setCount(count); 
}